﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace Common_Tools.Web_Help
{
    public class SendPay
    {

                /// <summary>
        /// c# 参数名ascii码从小到大排序(字典序)拼接
        /// </summary>
        /// <param name="dir"></param>
        /// <returns></returns>
        private static string AsciiDicToStr(Dictionary<string, string> dir)
        {
            string[] arrKeys = dir.Keys.ToArray();
            Array.Sort(arrKeys, string.CompareOrdinal);
            var sb = new StringBuilder();
            foreach (var key in arrKeys)
            {
                string value = dir[key];
                sb.Append(key + "=" + value + "&");
            }
            return sb.ToString().Substring(0, sb.ToString().Length - 1);
        }

        public static string md5(string str)
        {
            MD5 mD5 = new MD5CryptoServiceProvider();

            byte[] fromData = Encoding.UTF8.GetBytes(str);
            byte[] targetData = mD5.ComputeHash(fromData);

            string sign = null;

            for (int i = 0; i < targetData.Length; i++)
            {
                sign += targetData[i].ToString("x2");
            }

            return sign;
        }

        /// <summary>
        /// 发送
        /// </summary>
        /// <param name="req">支付参数</param>
        /// <param name="str"></param>
        public static String CreatePay(Req req) 
        {

            var dic = new Dictionary<string, string>();
            dic.Add("pid", pid); //商户ID "1000"
            dic.Add("type", req.type); //支付方式
            dic.Add("out_trade_no", req.out_trade_no);   //商户订单号
            dic.Add("notify_url", req.notify_url); //异步通知地址 不能携带参数 http 或者 https  例如: http://baidu.com/api/notify
            dic.Add("return_url", req.return_url);  //跳转通知地址  "www.baidu.com"
            dic.Add("name", req.name); //商品名称
            dic.Add("money", req.money); //商品金额
            dic.Add("clientip", req.clientip); //用户IP地址
            dic.Add("device", req.device);  //设备类型
            //dic.Add("param", req.param);  //附加参数 回调原样返回 可选

            //参数 排序
             var s = AsciiDicToStr(dic);   

            string key = "平台分配的key"; //"2342423dsfasfdasdfa";
             //签名md5 结果转小写
            req.sign = md5(s+key).ToLower();

           
             //新建一个StringBuilder类
            StringBuilder sbTemp = new StringBuilder();

            //发送链接
            sbTemp.Append("pid=" + pid + "&type=" + req.type + "&out_trade_no=" + req.out_trade_no + "&notify_url=" + req.notify_url + "&return_url=" + req.return_url + "&name=" + req.name + "&money=" + req.money + "&clientip=" + req.clientip + "&device=" + req.device +"&sign=" + req.sign + "&sign_type=" + "MD5");
           
            //对内容做Urlencode编码操作。
            byte[] bTemp = System.Text.Encoding.GetEncoding("UTF-8").GetBytes(sbTemp.ToString());
            //发送返回的结果存入result中
            String result = PostRequest("https://api.payqqpay.cn/mapi.php", bTemp);
            if (result.Contains(":1"))
            {
                str = true;
            }
            else
            {
                str = false;
            }
            return result.ToString();
        }
        //POST方式发送得结果
        private static String PostRequest(string url, byte[] bData)
        {
            System.Net.HttpWebRequest hwRequest;
            System.Net.HttpWebResponse hwResponse;
            string strResult = string.Empty;
            try
            {
                //获取上面的URL链接
                hwRequest = (System.Net.HttpWebRequest)System.Net.WebRequest.Create(url);
                //设置超时时间
                hwRequest.Timeout = 5000;
                //发送请求为POST
                hwRequest.Method = "POST";
                hwRequest.ContentType = "application/x-www-form-urlencoded";
                //bData的长度（也就是获取用内容，编码格式总长度）
                hwRequest.ContentLength = bData.Length;
                //发送
                System.IO.Stream smWrite = hwRequest.GetRequestStream();
                smWrite.Write(bData, 0, bData.Length);
                //释放资源
                smWrite.Close();
            }
            catch (System.Exception err)
            {
                WriteErrLog(err.ToString());
                return strResult;
            }

            //get response
            try
            {
                //使用hwResponse来获取数据
                hwResponse = (HttpWebResponse)hwRequest.GetResponse();
                StreamReader srReader = new StreamReader(hwResponse.GetResponseStream(), Encoding.ASCII);
                strResult = srReader.ReadToEnd();
                srReader.Close();
                hwResponse.Close();
            }
            catch (System.Exception err)
            {
                WriteErrLog(err.ToString());
            }

            return strResult;
        }
        //URLencode编码
        public static string UrlEncode(string str)
        {
            StringBuilder sb = new StringBuilder();
            byte[] byStr = System.Text.Encoding.UTF8.GetBytes(str); //默认是System.Text.Encoding.Default.GetBytes(str)
            for (int i = 0; i < byStr.Length; i++)
            {
                sb.Append(@"%" + Convert.ToString(byStr[i], 16));
            }

            return (sb.ToString());
        }
        private static void WriteErrLog(string strErr)
        {
            Console.WriteLine(strErr);
            System.Diagnostics.Trace.WriteLine(strErr);
        }


        /// <summary>
        /// 支付回调
        /// </summary>
        /// <param name="notify">回调参数</param>
        /// <returns></returns>
        public async Task PayNotify(HuliPayNotify notify)
        {
            var dic = new Dictionary<string, string>();

            dic.Add("pid", notify.pid.ToString());
            dic.Add("type", notify.type);
            dic.Add("out_trade_no", notify.out_trade_no);
            dic.Add("trade_no", notify.trade_no);
            dic.Add("money", notify.money);
            dic.Add("trade_status", notify.trade_status);

            //md5签名    
            var s = AsciiDicToStr(dic);

            //计算签名
            var sign = MD5Helper.md5(s + key);

            //计算的签名和回调的签名比较
            if(sign == notify.sign){

            }
        }

    }
}
